#include "Example.h"
#include <iostream>
#include <string>
using namespace std;

void Example::e1()
{
    // It's a good idea to initialize pointers
    // to NULL when you define them
    string* ptrToString = NULL;

    // Show that the address pointed to is zero
    cout << "ptrToString points to: " << ptrToString << endl;

    // Show that derefencing a NULL pointer is a bad idea
   // cout << "Contents of memory pointed to :" << *ptrToString << endl;

    // But once your pointer points to valid memory everything's ok
    string coolQuote("\"Welcome to the real world.\" - Morpheus");
    ptrToString = &coolQuote;
    cout << "ptrToString points to: " << ptrToString << endl;
    cout << "Contents of memory pointed to: " << *ptrToString << endl;

    // This is how we avoid crashing due to NULL pointers
    if(ptrToString != NULL)
        cout << *ptrToString << endl;
    else
        cout << "No quote available" << endl;
/**/

}
