#ifndef SHAPE_H_INCLUDED
#define SHAPE_H_INCLUDED

#include <SDL/SDL.h>
#include <SDL/SDL_gfxPrimitives.h>

class Shape {
	private:
		int red;        // RGB color codes
		int green;
		int blue;
		int transparency;   // Alpha blending. 0 - 255
		int x;          // Position on surface
		int y;
		int xStep;      // Distance to move on surface
		int yStep;
		SDL_Surface* pSurface;
		int width;      // Width of shape
	public:
		Shape(SDL_Surface* surface, int width);
		bool setPosition(int x, int y); // Set position on surface
		bool setMovement(int xSt, int ySt);
		void setColor(int r, int g, int b);
		void move();    // Move shape by steps set with setMovement
		void setTransparency(int alpha);
		void draw();    // Draw shape in surface buffer
};


#endif // SHAPE_H_INCLUDED
