#include <SDL/SDL.h>
#include <iostream>
#include "Shape.h"

using namespace std;

int main(int argc, char *argv[])
{
    // initialize SDL video
    if ( SDL_Init( SDL_INIT_VIDEO ) < 0 )
    {
        printf( "Unable to init SDL: %s\n", SDL_GetError() );
        return 1;
    }

    // make sure SDL cleans up before exit
    atexit(SDL_Quit);

    // create a new window
    SDL_Surface* screen = SDL_SetVideoMode(640, 480, 32, SDL_HWSURFACE|SDL_DOUBLEBUF);
    if ( !screen )
    {
        printf("Unable to set 640x480 video: %s\n", SDL_GetError());
        return 1;
    }

    // **** Display Shapes ****
	bool isRunning = true;
	Shape shape1( screen, 25 );
	Shape shape2(screen, 50);

	while(isRunning)
	{
        // clear screen
        SDL_FillRect(screen, 0, SDL_MapRGB(screen->format, 0, 0, 0));
		shape1.draw(); 			// draw the shapes on the screen
		shape2.draw();
        SDL_Flip(screen);  // flip buffer and display
        SDL_Delay(20);
		// Check to see if user quits
		SDL_Event event;
		while(SDL_PollEvent(&event))
		{
			switch(event.type)
			{
				case SDL_QUIT:
					isRunning = false;
					break;
				case SDL_KEYDOWN:
					if(event.key.keysym.sym == SDLK_ESCAPE)
						isRunning = false;
					break;
			}
		}

	}

	return 0;
}
